/*
Test Luxmeter
Jmd february 2026
*/
#include <lvgl.h>
#include <TFT_eSPI.h>
#include <BH1750.h>

#define SDA 21
#define SCL 22

BH1750 lightMeter;

lv_obj_t *label;

#define SCREEN_WIDTH 240
#define SCREEN_HEIGHT 320


#define DRAW_BUF_SIZE (SCREEN_WIDTH * SCREEN_HEIGHT / 10 * (LV_COLOR_DEPTH /8))
uint32_t draw_buf[DRAW_BUF_SIZE / 4];

void create_label(lv_obj_t *parent)
{
  label = lv_label_create(parent);
}

void Draw_Rectangle()
{
  lv_obj_t *rectangle = lv_obj_create(lv_screen_active());
  lv_obj_set_size(rectangle, 300, 150);
  lv_obj_set_pos(rectangle, 10, 50);

  static lv_style_t style;

  lv_style_init(&style);
  lv_style_set_bg_color(&style,lv_color_hex(0xFFffff));
  lv_style_set_bg_opa(&style, LV_OPA_0);
  lv_style_set_border_color(&style, lv_color_hex(0x000000));
  lv_style_set_border_width(&style, 5);
  lv_obj_add_style(rectangle, &style, 0);
}


void Draw_GUI(void)
  
  {
   lv_obj_t *screen = lv_scr_act();
   create_label(screen);

   Draw_Rectangle();

   static lv_style_t style_text;
   lv_style_init(&style_text);
   lv_style_set_text_font(&style_text, &lv_font_montserrat_26);
   lv_obj_add_style(label, &style_text, 0 );
   lv_obj_set_style_text_color(label, lv_color_hex(0xff0000), 0);
  }


void setup()
{
  Serial.begin(115200);
  Wire.begin(SDA,SCL);
  lightMeter.begin();

  Serial.println(F("BH1750 Test begin"));
  
  lv_init();

  lv_display_t * disp;
  disp = lv_tft_espi_create(SCREEN_WIDTH, SCREEN_HEIGHT, draw_buf, sizeof(draw_buf));
  lv_display_set_rotation(disp, LV_DISPLAY_ROTATION_270);

  Draw_GUI();

}
void loop()
{
  float lux = lightMeter.readLightLevel();
  Serial.print("Light: ");
  Serial.print(lux);
  Serial.println(" lx");
  char T[30] = "Lumiere = ";
  char buffer[10];
  sprintf(buffer, "%.2f", lux);
  strcat(T, buffer);
  lv_label_set_text(label, T);
  lv_obj_align(label, LV_ALIGN_CENTER, 0, 0);

  lv_task_handler();
  lv_tick_inc(100);
  delay(100);
}



