/* 
 * File:   main.c
 * Author: JMDefais
 * Pic 16F677A
 * Voltmeter
 * Created on 2 novembre 2025, 14:54
 */

#define _XTAL_FREQ 8000000 // Xtal 8 Mhz

#define RS RD2
#define EN RD3
#define D4 RD4
#define D5 RD5
#define D6 RD6
#define D7 RD7
#define LEDY RB2
#define LEDR RB1
#define BTN RB4

#include <xc.h>
#include <stdio.h>
#include "lcd.h"


// BEGIN CONFIG
#pragma config FOSC = HS // Oscillator Selection bits (HS oscillator)
#pragma config WDTE = OFF // Watchdog Timer Enable bit (WDT enabled)
#pragma config PWRTE = OFF // Power-up Timer Enable bit (PWRT disabled)
#pragma config BOREN = ON // Brown-out Reset Enable bit (BOR enabled)
#pragma config LVP = OFF // Low-Voltage (Single-Supply) In-Circuit Serial Programming Enable bit (RB3 is digital I/O, HV on MCLR must be used for programming)
#pragma config CPD = OFF // Data EEPROM Memory Code Protection bit (Data EEPROM code protection off)
#pragma config WRT = OFF // Flash Program Memory Write Enable bits (Write protection off; all program memory may be written to by EECON control)
#pragma config CP = OFF // Flash Program Memory Code Protection bit (Code protection off)
//END CONFIG

void ADC_Init()
{
  ADCON0 = 0x81;                //Turn ON ADC and Clock Selection
  TRISA  = 0x2F;               // Make RA5, RA3, RA2, RA1, RA0 input
  TRISE  = 0x07;               // Make RE0, RE1 and RE2 input
  ADCON1 = 0x80;                //RA0  RA7 entres analogiques Vref VDD
}

int GetADCValue(unsigned char Channel)
{
	ADCON0 &= 0xc7;         // Clear Channel selection bits
	ADCON0 |= (Channel<<3); // Select channel pin as ADC input
    
    __delay_ms(10);         // For Acqusition Time 
							// to charge up and show correct value
	GO_nDONE  = 1;		    // Enable Go/Done

	while(GO_nDONE);        // Wait for conversion completion

	return ((ADRESH<<8)+ADRESL);   // Return 10 bit ADC value
}


int main()
{
  TRISB1 = 0;//RB1 as Output PIN
  TRISB2 = 0;//RB2 as Output PIN
  TRISB4 = 1;//RB4 as Input PIN
  TRISD = 0x00;
  
  char value[50];
  float ADC_value = 0;
  float ADC_value_max = 4.98;
  uint8_t Ch = 0;
  
  Lcd_Init();               // Initialize LCD
  Lcd_Clear();
  Lcd_Set_Cursor(1,4);
  Lcd_Write_String("Voltmetre");
  Lcd_Set_Cursor(2,7);
  Lcd_Write_String("Jmd");
  __delay_ms(2000);
  ADC_Init();              // Initialize ADC
  while(1)
    {
    Lcd_Clear();           
    if (BTN == 0)           // Select channel AN0 - AN7 whith Switch
    {
        Ch = Ch + 1;
        if (Ch > 7)
        {
            Ch = 0;
        }
    }
    ADC_value = GetADCValue(Ch); // Read ADC value from RA0 pin
    ADC_value = (5.0/1024.0)*ADC_value; //Change in Volts
    if (ADC_value > ADC_value_max)
    {
        LEDR = 1;
    }
    else
    {
        LEDR = 0;
    }
    Lcd_Set_Cursor(1, 1);
    sprintf(value,"U = %.3f",ADC_value);    
    Lcd_Write_String(value);
    Lcd_Write_String(" Volts");
    Lcd_Set_Cursor(2,1);
    Lcd_Write_String("Channel ");
    Lcd_Write_Char(Ch + 48);
    LEDY = 1;
    __delay_ms(500); // Half second delay before next reading
    LEDY = 0;
  }
    
  return 0;
}

