
/*
 * Testeur de transistor avec LCD
 * JM Defais 2014
 */

#include <LiquidCrystal.h>

LiquidCrystal lcd(2,3,4,5,6,7);

void setup(void)
{
lcd.begin(16,2);
lcd.clear();
lcd.print("Testeur transistor");
delay(2000);
lcd.clear();
lcd.setCursor(0,0);
lcd.print("Gain =");
lcd.setCursor(0,1);
lcd.print("Vbe =");
lcd.setCursor(9,1);
lcd.print("V");
}


void loop(void) 
{
  long UC = analogRead(A0);                //lecture de U collecteur/emetteur
  int K1 = analogRead(A1);                 // lecture de l'interrupteur
  long Vb = analogRead(A2);                // lecture de Vbe/ vbc
  if (K1 != 0)                             // test de la position de l'interrupteur
  {
    lcd.setCursor(12,1);
    lcd.print("NPN");
  }
  else
  {
    lcd.setCursor(12,1);
    lcd.print("PNP");
    Vb= UC - Vb;                          // Calcul de Vbe pour PNP
  }
  lcd.setCursor(5,1);
  lcd.print(Vb*((float)5/(float)1023));  // Calcul et affichage de Vbe
  long U2 = ((UC*50)- (Vb*50000/1023));
  
  long U1 = (51150 - (UC*50));
  lcd.setCursor(7,0);
  lcd.print(U1/(U2/100));                //Calcul et affichage du gain
  delay(500);
}


